/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.parsing;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.build.IProblem;
import com.aptana.editor.coffee.parsing.ast.CoffeeAccessNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeArrNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeAssignNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeBlockNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeCallNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeCatchNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeClassNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeCodeNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeCommentNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeExistenceNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeExtendsNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeForNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeForSourceNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeForVariablesNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeIfNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeIndexNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeLiteralNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeObjNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeOpNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeParamNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeParensNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeParseRootNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeRangeNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeReturnNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeSliceNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeSplatNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeSwitchNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeThrowNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeTryNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeValueNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeWhenNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeWhileNode;
import com.aptana.editor.coffee.parsing.lexer.CoffeeScanner;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.ast.ParseRootNode;
import java.util.ArrayList;
import java.util.List;

public class CoffeeParser
extends Parser
implements IParser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjMmTy55KJdysb44hkBY3ILKvA4Y0QUf4gJGH4UfUU42G20G8IGQe51IoeOA#87R6WQ4GH2ofM5445516iW28YCD$$bTlTI#wE#xuzVX$wE$pDpfltPlupRzvxixktaIXr9BrDcwa9BQQRwJQwdUwWF7gQMjF5D8ukfubq1JrCSoc1NgH2Uf0Uec4qd2wZ4JIIHj5e6aDZwLsZ1TMZlsWNhQP4IWBMBFg1uW8GhwSRw2QwHIDMfkfq3hUEo7CZU7ubb6UQG$sCQjIDpgMsr8Ooeu1OcjmIKSP85qObnj8IKUMcIqI8WyCYscqVjMUMLneDQ03TI4lfFBg4BgK#r5$CY0OQzIFo#rXOlr$hRDU9LhQDSXgngq0qQaGXs$lfHse8nAZi1BeeGgJmvwEEKTT8CzAfdc7WbDJ7#MXACwE7QsGOFcfF#S1jHtSxnwKq8uxIASEe2TokHX9mzz1zpBIGhj7deXxTAi$xGJf4Tz4AMabtqYJQIKVe9xa2rz4gUf#cq9VqAZr2lzDX#fNcymcgImLHYC#VHtMYN1JlD3BgY7bM3uZf6$hALh6K9x4Z6ZZrPPn7xOlxCihQV8L2xOcH3evd6iAALr8lNJdg#Ik7KK$DswZgs6jlh5draBOgk#hQ89BzONZ2djnGSooYlbma$gDcYdEHqOG#ZsX77WZhyRU8C9B3OaI2KDOnGefZXF2vZmGXrJ521SS85HqZL7ACKCKnGZN723KS8vpj6A6vOuIMZX4k28lWzCwtWWQX$ZcjeWNsIecA$OQgsCQvvhFUcqOjlZ6Y#GuzbVEbR3oFZ8yeZXp7AvTxIcTYlpTDfcaq8wAOhdOygmME4HOvHhZsb6QsWARJlH75yUGfZcCUFHTH76iTP$HvnmWldz9SBC6xQcf4SNpWU2RR72FiSupmyodDvZBOHVQ#yuVZcVpf6E5lfmX6#ESPfzbSJW$W7Xf97BKTpoJJCK93nmYD7ICqTOmG$idCwOh6x6FsCVkOVSm#PX#pZzd7xFzvzkgNaV$DlXoLqVuLYYaRzfvGsElazvYfvAKpgJoTGQNajzjADhb0zF1JeiUe9xyQ5HXL9SuGUjpyjd54UYcY7VPdOICvu8jro4ZfDUeiuzXk#isIevR6CxH6Qcm8Z9GwsMHBku0Qor4H#HARnWIZSeaedaLkNfTVmeJ5Iq7nheIEI#h8RD1JDgqNIY2gwnDIio0eNZ#jquEwQyGjGVNiU1l3uAKXldJAeFkf9k8KUfjiUiTicbVHR1DHwBqL0gz0uXLGRRw1tf6QlfD6ABHS0Jkde8HcRRg7lf2QjKnDIqTzExFagbBplI2Q$RIk#8OkTCugjY#s1erMZ7mMPXvsV1MxM25XzObbPQJ8aK#DU3doRJ7FzKnPd2IlANse4FaZ$b3kooBowkzeBVpVqNGKHuqiMcwKmPamepAyy9Ob4SkRY2h2y#c4GKOYhoJMlsINDd$9Faxh3NaAg5L03hSY2x2I8#mVCHf9JwLWjHU#5Vfkew9njj4CljL9FrFQT3NHLEzPz3q$2IiHNqlx$FcuNq9yl#Wr8tzywACIVKL4EXjavaL4Wd#yKLob9FUnb4LED#fC1P6aXOYPx765bJuACIQoKm6v#zYCGkIGZ3Zaa6Hxgt46sdiW7JTZiDgX$H9z1vnIu7jrHXCC5zgYsWeIrLQG7$E8934Y$baZwdeaG5BNpbOynlcuP0NH4N#dSJ7sUm$gYTNeXVNeZHNfYxFG7wiqa0RHODJyeK5#nHX7sPH3uoaNIErm3f8rrXJgWdjBQ4JnLmS9k0CwzroN9iYxJ2VSPoRHv2WWdeDQAX1LZD50h0jCWQYGee4OsZQTPg0IrQS6b4VdeKPaKKCve$cq82hhhBAT6RLiHn#n0iwObUrex8JehPSuR#AKJA5vE1$Hmor4NKodES0jY1AkpyJDn5F153mJJ1KbXEBqkV3Ff3IgOLdKn1HKDG#gMYggcbY1YgXlbN1FhO9xUJNSMMlWJdqs46O2sNbyVkyAAGFnEOqi3$FqXOb9UH8xeaaKVAM7zHKALNp1RkFOUoYhT4IaAaUYMJcQwdctTEorE#ny8MsL5tMDnltev7DiRywnCysDIXrpZX53Y27444vF1AVrBvqQeVuvHV45LCfql0MhQjRKh6PTwG9u#l$Fzm9vZ$ith9mzumNmbdPQpEfqG72#ctEZiaTEbpXE1mIdkPY0Pzn$IovEXsmcnh8PjMnsfrQnR9vM24vND6OViu$Pn#nZzZ7xc7tCFcR$pxDNJv5E$IiKIywqzOJ2RYw$nrn8vr8jgarrv7VMcdYNjsIVx6aaUvfA71#rb3WpRDysKgMNN6eHvbauTAHNQo#MtmmvQcc8kGkDjiKYRMEJBMqV8XEZLkHA8mtn5O#Y0#QKAtCZjCi7nKk3JeRKyUdlLtRCueZgEaDg#eBYJT0wudkjBuoU7IytZ9xuCYHodeQSPqYzxX54M7obxNZgswMFPY9$olFiaqOej382TewlXEPCl7zc5iEpTDGliPRSk5YCzWmgNP51eTEusBve5ZHQCJ8zp3pi#2fsFxuzJxbo94tF8w#OvqHJ3lGsIoFwz8gdOqJDeR7voxEAmaUjiG8jpFTqOJKTtjJApZ8H5LuJUUB4zz1U6Y$Nn1k4jh9g7P33Pi0JLcAabpdIM8xbmsgQkNPN0Y4D8nawbZHfasdQgDuyM3M2LU0E41APKZgGP7pCPdpfQ4VIXqWO$yWdhrR5pD2IhdHQQcANf0KYmTKMLpW9Smm#fbQz6JKteq0EHLJK2rUHJumXdoAgGVuOh7Pel#0TGVcWQLet7vcV9gkj855j1VddbIf8Z4XySqHVKmCa$vwouaa3PGJH8QFL7Fb7KN4LG8s9IbTJigU7uAfTkXNa4Rez19UnuBF0ju3V2RuKV3sHUnNu3l3kuCU8l4U8obI3xM5mWJ4D7FPkG9M1lUTwSDXx#m2ZckNF$ONYj1$j$Vv#Eo5M7OzH7lP9gbrclRPVfhYhcUv7J9vzu2AcLAAoYCax4WDQtrYdCM$JyavW5AfsmZBq8xwohMo#jsc#HFCjsb#SvlKjtOHhCBuLVBQE3Nb8M0j#Hx1vbPndmiz4YSc8DmSnYDoj3gwNQEZOdu9ELV3UH4cLzTX4xNkJfKzDh7PPiHPtGN#ebh4cIT#3OqsDN73aBouVz3hcratfUCV1PhfgUsxGVPCip5Ahmiyh2J5w1cf$M1TF5QBaoi5rumu0#qhuzc8E5wAD$LOEQ#ZUeEUrmeOx7EDFOXnvTd#gntsWZz0dyhTFpn$huaQE4Z1lD#RcVb3h7jLpQW7ggDjTB7nFjlQp1xh78ICMxojwR1FeGqktdCWhybGE#VGy1FsBLByh4txN1CxHFH4wcu6rNScfjGJ7qTqDUwo3Pmte8EWGPB6VlJhFYxNltJOiiR#VWvxOxtgFUrr4AU8irWgUOm$3PntenO4tKdt6NjluhphsKT0vKsFMr6FlQ$aiq6RTxWJgPjcdO3syRrXoSaF8NK0wnt6z5KzOhVMnLfulWyMgyL5ZKaH#coFU#jf6r9BwuCYNzrrmvCcBTKmHUH1xQ11eiSxhytgElsXvXuNj6eZBUDsUYTXGOrmhmH6l2zXn6y6$0lyJ$0JuKQ9up3rXCNXRy2NW8t3kEeBF1OTT$0E8upDmsAQWBheFsd9RnMeRwuFD5$4TKkCqozAbOugxixHjKyNZzwWQd908lWuSw#fURs4OkXwGhlLnvMsOY3ckAtJEiVhSZscz8Pg$eFaUdQEqmBMXYJPR0$xl0VyWsBo24VI$XVukv2qU$BlWEedLzLn6Qxabw6FTrwcalgUqpRO7v78umnMrd0Sv2nndsODxOE8pu9sHhszizhXN9grGxLBjT9zjBPAJmi$9c6nhtnrUb$IPfjMO$r8Tun$mjxoaRXBslsSRkDZRMLQ$sFD9g9cUNKhsehwuAu5gADcTh$acpVy67T3pSjdctK7xAG86xj#UMq73zDY2m5ZYJgXxUj9Ew1O2Jzz$uvg9kGJgUd0UFJTQihUirIw5FUCjiibuflJMKMsNtkFUDstZOqNT15y4li$MZ#SHx#7YETF#jwlxX0Vt1U$QOECwTkIDFWaSy$wbTTRPyXiNg5Fg7VGTjsJw1BB7aesbWVh9s8#f9paNoGsWOrkRv9wGay2l07U3urab5SytoRXNf9vXyzLAXS17#M$#YwSozBaNuvGpAXDt1g5QCqu#u#xA7K3jGTWzZEh7Cq05e8ay0TTSnXsDn$9upk5inbC2ty9u3kIRGTVn8l7$6F3be34Wt2luCZx4U6vWr02#GshU3jh27$3rl90FyWP8TuDU03tFQ$avVbP7kqRp0$mR$yg$yC$y4$$8#taVemRpDtBiQtwPN#9r$2BVnNUI$iV8DVy0sil7#0XFuqbeNmhw67G927bZr03kpcz8VPntVXhq6g$dvNmhlyglyBUyctVnJZbUg75dyPzycF$Wtz56FS1ibyd#fLp4tVWYjDf9kIttqHPzvNKUuox0M0o#MigpGTCPJnsSPyOyJ5w7ya0jp#T7#67mX$X1eD$6ZylSFG5wb77luHscPJ$G59xCU$Wx$epnhCbNyQTwR3j$oTlu2$uSxSTbrb5JU1K$nW$m$MZTn$Vo0ExF2tYGr1yYhuCPJqRSXc$YnMAjGDU2tkFDZBiglyDlyrkyYT$azzNyfGsUfnZtFCRp5uy6ZTG36sWXhWlnxhGGRqzJmQVYVNigskAlZmKDAqP3$WlAbRz0kV0cPk0jJ57$OZGAuwFmVf#FTZxQ#RezpKR3WJCSV11e1CP7G1wCjY2nHddWSoIvg12y4EE5Q5#5jfqcehytU6$9LRkVZVe4eKdGiyYGD07O4o0BcWzPq2KKZpT40XaW5qZ8YPG3EGTwEUZBGLzWEu7wegt808dVDmXaK07Q1T0Hlz89wW6vfwHucW5PqAMmNm3R1UWND1bzao5FXewYHBeSVOBcIdBH6EYDaJmU97xfSz5bw1i0Fa3#xYBUvUDDFXRS8eF6WmiQPwDkcYwMvAAPqFFJR4akceSnHV4sIfIK3R$PUAlEHbysv5cmcIL$Ot61ucae#53eZ4R$QBJzD18wuSbr4agGVD5$0B9qNu0=");
    private WorkingParseResult fWorking;

    public synchronized ParseResult parse(IParseState parseState) throws Exception {
        WorkingParseResult working = new WorkingParseResult();
        this.parse(parseState, working);
        return working.getImmutableResult();
    }

    protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fWorking = working;
        try {
            String source = parseState.getSource();
            CoffeeScanner scanner = new CoffeeScanner();
            scanner.setSource(source);
            ParseRootNode result = (ParseRootNode)this.parse(scanner);
            int start = parseState.getStartingOffset();
            int end = start + parseState.getSource().length() - 1;
            result.setLocation(start, end);
            working.setParseResult((IParseRootNode)result);
            result.setCommentNodes(scanner.getComments().toArray(new IParseNode[scanner.getComments().size()]));
        }
        finally {
            this.fWorking = null;
        }
    }

    public CoffeeParser() {
        super(PARSING_TABLES);
        this.report = new CoffeeEvents();
    }

    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                return new CoffeeParseRootNode();
            }
            case 1: {
                Symbol _symbol_b = this._symbols[offset + 1];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeParseRootNode(new Symbol[]{b});
            }
            case 2: {
                Symbol _symbol_b = this._symbols[offset + 1];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeParseRootNode(new Symbol[]{b});
            }
            case 3: {
                Symbol _symbol_l = this._symbols[offset + 1];
                CoffeeNode l = (CoffeeNode)((Object)_symbol_l.value);
                return new CoffeeBlockNode(l);
            }
            case 4: {
                Symbol _symbol_b = this._symbols[offset + 1];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                Symbol _symbol_l = this._symbols[offset + 3];
                CoffeeNode l = (CoffeeNode)((Object)_symbol_l.value);
                b.addChild((IParseNode)l);
                return b;
            }
            case 11: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new CoffeeLiteralNode(s);
            }
            case 23: {
                return new CoffeeBlockNode();
            }
            case 24: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return b;
            }
            case 25: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new CoffeeLiteralNode(i);
            }
            case 26: {
                Symbol _symbol_n = this._symbols[offset + 1];
                String n = (String)_symbol_n.value;
                return new CoffeeLiteralNode(n);
            }
            case 27: {
                Symbol _symbol_s = this._symbols[offset + 1];
                String s = (String)_symbol_s.value;
                return new CoffeeLiteralNode(s);
            }
            case 29: {
                Symbol _symbol_j = this._symbols[offset + 1];
                String j = (String)_symbol_j.value;
                return new CoffeeLiteralNode(j);
            }
            case 30: {
                Symbol _symbol_r = this._symbols[offset + 1];
                String r = (String)_symbol_r.value;
                return new CoffeeLiteralNode(r);
            }
            case 31: {
                Symbol _symbol_b = this._symbols[offset + 1];
                String b = (String)_symbol_b.value;
                CoffeeLiteralNode val = new CoffeeLiteralNode(b);
                if (b == "undefined") {
                    val.isUndefined = true;
                }
                return val;
            }
            case 32: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeAssignNode(a, e);
            }
            case 33: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                Symbol _symbol_e = this._symbols[offset + 4];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeAssignNode(a, e);
            }
            case 34: {
                Symbol _symbol_o = this._symbols[offset + 1];
                CoffeeNode o = (CoffeeNode)((Object)_symbol_o.value);
                return new CoffeeValueNode(o);
            }
            case 35: {
                Symbol _symbol_o = this._symbols[offset + 1];
                CoffeeNode o = (CoffeeNode)((Object)_symbol_o.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeAssignNode(new CoffeeValueNode(o), e, "object");
            }
            case 36: {
                Symbol _symbol_o = this._symbols[offset + 1];
                CoffeeNode o = (CoffeeNode)((Object)_symbol_o.value);
                Symbol _symbol_e = this._symbols[offset + 4];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeAssignNode(new CoffeeValueNode(o), e, "object");
            }
            case 41: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeReturnNode(e);
            }
            case 42: {
                return new CoffeeReturnNode();
            }
            case 43: {
                Symbol _symbol_h = this._symbols[offset + 1];
                String h = (String)_symbol_h.value;
                return new CoffeeCommentNode(h);
            }
            case 44: {
                Symbol _symbol_p = this._symbols[offset + 2];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                CoffeeParamNode[] p = _list_p == null ? new CoffeeParamNode[]{} : _list_p.toArray(new CoffeeParamNode[_list_p.size()]);
                Symbol _symbol_f = this._symbols[offset + 4];
                String f = (String)_symbol_f.value;
                Symbol _symbol_b = this._symbols[offset + 5];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeCodeNode(p, b, f);
            }
            case 45: {
                Symbol _symbol_f = this._symbols[offset + 1];
                String f = (String)_symbol_f.value;
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeCodeNode(b, f);
            }
            case 46: {
                return new Symbol((Object)"func");
            }
            case 47: {
                return new Symbol((Object)"boundfunc");
            }
            case 50: {
                Symbol _symbol_p = this._symbols[offset + 1];
                CoffeeParamNode p = (CoffeeParamNode)((Object)_symbol_p.value);
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 51: {
                Symbol _symbol_l = this._symbols[offset + 1];
                ArrayList _list_l = (ArrayList)_symbol_l.value;
                CoffeeParamNode[] l = _list_l == null ? new CoffeeParamNode[]{} : _list_l.toArray(new CoffeeParamNode[_list_l.size()]);
                Symbol _symbol_p = this._symbols[offset + 3];
                CoffeeParamNode p = (CoffeeParamNode)((Object)_symbol_p.value);
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 3].value);
                return this._symbols[offset + 1];
            }
            case 52: {
                Symbol _symbol_v = this._symbols[offset + 1];
                CoffeeNode v = (CoffeeNode)((Object)_symbol_v.value);
                return new CoffeeParamNode(v);
            }
            case 53: {
                Symbol _symbol_v = this._symbols[offset + 1];
                CoffeeNode v = (CoffeeNode)((Object)_symbol_v.value);
                return new CoffeeParamNode(v, null, true);
            }
            case 54: {
                Symbol _symbol_v = this._symbols[offset + 1];
                CoffeeNode v = (CoffeeNode)((Object)_symbol_v.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeParamNode(v, e);
            }
            case 59: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeSplatNode(e);
            }
            case 60: {
                Symbol _symbol_i = this._symbols[offset + 1];
                CoffeeLiteralNode i = (CoffeeLiteralNode)((Object)_symbol_i.value);
                return new CoffeeValueNode(i);
            }
            case 61: {
                Symbol _symbol_v = this._symbols[offset + 1];
                CoffeeValueNode v = (CoffeeValueNode)((Object)_symbol_v.value);
                Symbol _symbol_a = this._symbols[offset + 2];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                return v.push(a);
            }
            case 62: {
                Symbol _symbol_i = this._symbols[offset + 1];
                CoffeeCallNode i = (CoffeeCallNode)((Object)_symbol_i.value);
                Symbol _symbol_a = this._symbols[offset + 2];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                return new CoffeeValueNode(i, a);
            }
            case 65: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeArrNode a = (CoffeeArrNode)((Object)_symbol_a.value);
                return new CoffeeValueNode(a);
            }
            case 66: {
                Symbol _symbol_o = this._symbols[offset + 1];
                CoffeeObjNode o = (CoffeeObjNode)((Object)_symbol_o.value);
                return new CoffeeValueNode(o);
            }
            case 68: {
                Symbol _symbol_l = this._symbols[offset + 1];
                CoffeeLiteralNode l = (CoffeeLiteralNode)((Object)_symbol_l.value);
                return new CoffeeValueNode(l);
            }
            case 69: {
                Symbol _symbol_p = this._symbols[offset + 1];
                CoffeeParensNode p = (CoffeeParensNode)((Object)_symbol_p.value);
                return new CoffeeValueNode(p);
            }
            case 70: {
                Symbol _symbol_r = this._symbols[offset + 1];
                CoffeeRangeNode r = (CoffeeRangeNode)((Object)_symbol_r.value);
                return new CoffeeValueNode(r);
            }
            case 72: {
                Symbol _symbol_i = this._symbols[offset + 2];
                CoffeeLiteralNode i = (CoffeeLiteralNode)((Object)_symbol_i.value);
                return new CoffeeAccessNode(i);
            }
            case 73: {
                Symbol _symbol_i = this._symbols[offset + 2];
                CoffeeLiteralNode i = (CoffeeLiteralNode)((Object)_symbol_i.value);
                return new CoffeeAccessNode(i, "soak");
            }
            case 74: {
                Symbol _symbol_i = this._symbols[offset + 2];
                CoffeeLiteralNode i = (CoffeeLiteralNode)((Object)_symbol_i.value);
                return new CoffeeAccessNode(i, "proto");
            }
            case 75: {
                return new CoffeeAccessNode(new CoffeeLiteralNode("prototype"));
            }
            case 77: {
                Symbol _symbol_v = this._symbols[offset + 2];
                CoffeeIndexNode v = (CoffeeIndexNode)((Object)_symbol_v.value);
                return v;
            }
            case 78: {
                Symbol _symbol_i = this._symbols[offset + 2];
                CoffeeIndexNode i = (CoffeeIndexNode)((Object)_symbol_i.value);
                i.soak = true;
                return i;
            }
            case 79: {
                Symbol _symbol_i = this._symbols[offset + 2];
                CoffeeIndexNode i = (CoffeeIndexNode)((Object)_symbol_i.value);
                i.proto = true;
                return i;
            }
            case 80: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeIndexNode(e);
            }
            case 81: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CoffeeRangeNode s = (CoffeeRangeNode)((Object)_symbol_s.value);
                return new CoffeeSliceNode(s);
            }
            case 82: {
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                Symbol _symbol_c = this._symbols[offset + 3];
                String c = (String)_symbol_c.value;
                return new CoffeeObjNode(c, l);
            }
            case 83: {
                return new Symbol(new ArrayList());
            }
            case 84: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                ArrayList<CoffeeNode> lst = new ArrayList<CoffeeNode>();
                lst.add(a);
                return new Symbol(lst);
            }
            case 85: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_a = this._symbols[offset + 3];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                l.add(a);
                return new Symbol((Object)l);
            }
            case 86: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_a = this._symbols[offset + 4];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                l.add(a);
                return new Symbol((Object)l);
            }
            case 87: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_a = this._symbols[offset + 4];
                List a = (List)_symbol_a.value;
                l.addAll(a);
                return new Symbol((Object)l);
            }
            case 88: {
                return new CoffeeClassNode();
            }
            case 89: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeClassNode(null, null, b);
            }
            case 90: {
                Symbol _symbol_v = this._symbols[offset + 3];
                CoffeeValueNode v = (CoffeeValueNode)((Object)_symbol_v.value);
                return new CoffeeClassNode(null, v);
            }
            case 91: {
                Symbol _symbol_v = this._symbols[offset + 3];
                CoffeeValueNode v = (CoffeeValueNode)((Object)_symbol_v.value);
                Symbol _symbol_b = this._symbols[offset + 4];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeClassNode(null, v, b);
            }
            case 92: {
                Symbol _symbol_s = this._symbols[offset + 2];
                CoffeeValueNode s = (CoffeeValueNode)((Object)_symbol_s.value);
                return new CoffeeClassNode(s);
            }
            case 93: {
                Symbol _symbol_s = this._symbols[offset + 2];
                CoffeeValueNode s = (CoffeeValueNode)((Object)_symbol_s.value);
                Symbol _symbol_b = this._symbols[offset + 3];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeClassNode(s, null, b);
            }
            case 94: {
                Symbol _symbol_s = this._symbols[offset + 2];
                CoffeeValueNode s = (CoffeeValueNode)((Object)_symbol_s.value);
                Symbol _symbol_v = this._symbols[offset + 4];
                CoffeeValueNode v = (CoffeeValueNode)((Object)_symbol_v.value);
                return new CoffeeClassNode(s, v);
            }
            case 95: {
                Symbol _symbol_s = this._symbols[offset + 2];
                CoffeeValueNode s = (CoffeeValueNode)((Object)_symbol_s.value);
                Symbol _symbol_v = this._symbols[offset + 4];
                CoffeeValueNode v = (CoffeeValueNode)((Object)_symbol_v.value);
                Symbol _symbol_b = this._symbols[offset + 5];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeClassNode(s, v, b);
            }
            case 96: {
                Symbol _symbol_v = this._symbols[offset + 1];
                CoffeeValueNode v = (CoffeeValueNode)((Object)_symbol_v.value);
                Symbol _symbol_o = this._symbols[offset + 2];
                Boolean o = (Boolean)_symbol_o.value;
                Symbol _symbol_a = this._symbols[offset + 3];
                List a = (List)_symbol_a.value;
                return new CoffeeCallNode(v, a, o);
            }
            case 97: {
                Symbol _symbol_i = this._symbols[offset + 1];
                CoffeeCallNode i = (CoffeeCallNode)((Object)_symbol_i.value);
                Symbol _symbol_o = this._symbols[offset + 2];
                Boolean o = (Boolean)_symbol_o.value;
                Symbol _symbol_a = this._symbols[offset + 3];
                List a = (List)_symbol_a.value;
                return new CoffeeCallNode(i, a, o);
            }
            case 98: {
                ArrayList<CoffeeSplatNode> args = new ArrayList<CoffeeSplatNode>();
                args.add(new CoffeeSplatNode(new CoffeeLiteralNode("arguments")));
                return new CoffeeCallNode("super", args);
            }
            case 99: {
                Symbol _symbol_a = this._symbols[offset + 2];
                List a = (List)_symbol_a.value;
                return new CoffeeCallNode("super", a);
            }
            case 100: {
                return new Symbol((Object)false);
            }
            case 101: {
                return new Symbol((Object)true);
            }
            case 102: {
                return new Symbol(new ArrayList());
            }
            case 103: {
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                return new Symbol((Object)l);
            }
            case 104: {
                return new CoffeeValueNode(new CoffeeLiteralNode("this"));
            }
            case 105: {
                return new CoffeeValueNode(new CoffeeLiteralNode("this"));
            }
            case 106: {
                Symbol _symbol_i = this._symbols[offset + 2];
                CoffeeLiteralNode i = (CoffeeLiteralNode)((Object)_symbol_i.value);
                return new CoffeeValueNode(new CoffeeLiteralNode("this"), new CoffeeAccessNode(i), "this");
            }
            case 107: {
                return new CoffeeArrNode(new ArrayList<CoffeeNode>());
            }
            case 108: {
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                return new CoffeeArrNode(l);
            }
            case 109: {
                return new Symbol((Object)"inclusive");
            }
            case 110: {
                return new Symbol((Object)"exclusive");
            }
            case 111: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeRangeNode(e, x, r);
            }
            case 112: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                String r = (String)_symbol_r.value;
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeRangeNode(e, x, r);
            }
            case 113: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                String r = (String)_symbol_r.value;
                return new CoffeeRangeNode(e, null, r);
            }
            case 114: {
                Symbol _symbol_r = this._symbols[offset + 1];
                String r = (String)_symbol_r.value;
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeRangeNode(null, e, r);
            }
            case 115: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                ArrayList<CoffeeNode> lst = new ArrayList<CoffeeNode>();
                lst.add(a);
                return new Symbol(lst);
            }
            case 116: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_a = this._symbols[offset + 3];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                l.add(a);
                return new Symbol((Object)l);
            }
            case 117: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_a = this._symbols[offset + 4];
                CoffeeNode a = (CoffeeNode)((Object)_symbol_a.value);
                l.add(a);
                return new Symbol((Object)l);
            }
            case 118: {
                Symbol _symbol_l = this._symbols[offset + 2];
                List l = (List)_symbol_l.value;
                return new Symbol((Object)l);
            }
            case 119: {
                Symbol _symbol_l = this._symbols[offset + 1];
                List l = (List)_symbol_l.value;
                Symbol _symbol_a = this._symbols[offset + 4];
                List a = (List)_symbol_a.value;
                l.addAll(a);
                return new Symbol((Object)l);
            }
            case 122: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                ArrayList<CoffeeNode> lst = new ArrayList<CoffeeNode>();
                lst.add(e);
                return new Symbol(lst);
            }
            case 123: {
                Symbol _symbol_s = this._symbols[offset + 1];
                List s = (List)_symbol_s.value;
                Symbol _symbol_e = this._symbols[offset + 3];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                s.add(e);
                return new Symbol((Object)s);
            }
            case 124: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeTryNode(b);
            }
            case 125: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                CoffeeCatchNode c = (CoffeeCatchNode)((Object)_symbol_c.value);
                return new CoffeeTryNode(b, c.getIdentifier(), c.getBlock());
            }
            case 126: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                Symbol _symbol_l = this._symbols[offset + 4];
                CoffeeBlockNode l = (CoffeeBlockNode)((Object)_symbol_l.value);
                return new CoffeeTryNode(b, null, null, l);
            }
            case 127: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                Symbol _symbol_c = this._symbols[offset + 3];
                CoffeeCatchNode c = (CoffeeCatchNode)((Object)_symbol_c.value);
                Symbol _symbol_l = this._symbols[offset + 5];
                CoffeeBlockNode l = (CoffeeBlockNode)((Object)_symbol_l.value);
                return new CoffeeTryNode(b, c.getIdentifier(), c.getBlock(), l);
            }
            case 128: {
                Symbol _symbol_i = this._symbols[offset + 2];
                CoffeeLiteralNode i = (CoffeeLiteralNode)((Object)_symbol_i.value);
                Symbol _symbol_b = this._symbols[offset + 3];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeCatchNode(i, b);
            }
            case 129: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeThrowNode(e);
            }
            case 130: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeParensNode(b);
            }
            case 131: {
                Symbol _symbol_b = this._symbols[offset + 3];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeParensNode(b);
            }
            case 132: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeWhileNode(e);
            }
            case 133: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeWhileNode(e, x);
            }
            case 134: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeWhileNode(e, true);
            }
            case 135: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeWhileNode(e, x, true);
            }
            case 136: {
                Symbol _symbol_w = this._symbols[offset + 1];
                CoffeeWhileNode w = (CoffeeWhileNode)((Object)_symbol_w.value);
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return w.addBody(b);
            }
            case 137: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CoffeeNode s = (CoffeeNode)((Object)_symbol_s.value);
                Symbol _symbol_w = this._symbols[offset + 2];
                CoffeeWhileNode w = (CoffeeWhileNode)((Object)_symbol_w.value);
                return w.addBody(new CoffeeBlockNode(s));
            }
            case 138: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_w = this._symbols[offset + 2];
                CoffeeWhileNode w = (CoffeeWhileNode)((Object)_symbol_w.value);
                return w.addBody(new CoffeeBlockNode(e));
            }
            case 139: {
                Symbol l = this._symbols[offset + 1];
                return l;
            }
            case 140: {
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeWhileNode(new CoffeeLiteralNode("true")).addBody(b);
            }
            case 141: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeWhileNode(new CoffeeLiteralNode("true")).addBody(new CoffeeBlockNode(e));
            }
            case 142: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CoffeeNode s = (CoffeeNode)((Object)_symbol_s.value);
                Symbol _symbol_f = this._symbols[offset + 2];
                CoffeeForSourceNode f = (CoffeeForSourceNode)((Object)_symbol_f.value);
                return new CoffeeForNode(s, f);
            }
            case 143: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_f = this._symbols[offset + 2];
                CoffeeForSourceNode f = (CoffeeForSourceNode)((Object)_symbol_f.value);
                return new CoffeeForNode(e, f);
            }
            case 144: {
                Symbol _symbol_f = this._symbols[offset + 1];
                CoffeeForSourceNode f = (CoffeeForSourceNode)((Object)_symbol_f.value);
                Symbol _symbol_b = this._symbols[offset + 2];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeForNode(b, f);
            }
            case 145: {
                Symbol _symbol_r = this._symbols[offset + 2];
                CoffeeRangeNode r = (CoffeeRangeNode)((Object)_symbol_r.value);
                return new CoffeeForSourceNode(new CoffeeValueNode(r));
            }
            case 146: {
                Symbol _symbol_f = this._symbols[offset + 1];
                CoffeeForVariablesNode f = (CoffeeForVariablesNode)((Object)_symbol_f.value);
                Symbol _symbol_s = this._symbols[offset + 2];
                CoffeeForSourceNode s = (CoffeeForSourceNode)((Object)_symbol_s.value);
                s.own = f.own;
                s.name = f.getChild(0);
                s.index = f.getChild(1);
                return s;
            }
            case 147: {
                Symbol _symbol_f = this._symbols[offset + 2];
                CoffeeForVariablesNode f = (CoffeeForVariablesNode)((Object)_symbol_f.value);
                return f;
            }
            case 148: {
                Symbol _symbol_f = this._symbols[offset + 3];
                CoffeeForVariablesNode f = (CoffeeForVariablesNode)((Object)_symbol_f.value);
                f.own = true;
                return f;
            }
            case 150: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeArrNode a = (CoffeeArrNode)((Object)_symbol_a.value);
                return new CoffeeValueNode(a);
            }
            case 151: {
                Symbol _symbol_o = this._symbols[offset + 1];
                CoffeeObjNode o = (CoffeeObjNode)((Object)_symbol_o.value);
                return new CoffeeValueNode(o);
            }
            case 152: {
                Symbol _symbol_f = this._symbols[offset + 1];
                CoffeeNode f = (CoffeeNode)((Object)_symbol_f.value);
                return new CoffeeForVariablesNode(f);
            }
            case 153: {
                Symbol _symbol_f = this._symbols[offset + 1];
                CoffeeNode f = (CoffeeNode)((Object)_symbol_f.value);
                Symbol _symbol_v = this._symbols[offset + 3];
                CoffeeNode v = (CoffeeNode)((Object)_symbol_v.value);
                return new CoffeeForVariablesNode(f, v);
            }
            case 154: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeForSourceNode(e);
            }
            case 155: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeForSourceNode(e, true);
            }
            case 156: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeForSourceNode(e, x);
            }
            case 157: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeForSourceNode(e, x, true);
            }
            case 158: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeForSourceNode(e, null, x);
            }
            case 159: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                Symbol _symbol_p = this._symbols[offset + 6];
                CoffeeNode p = (CoffeeNode)((Object)_symbol_p.value);
                return new CoffeeForSourceNode(e, x, p);
            }
            case 160: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 4];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                Symbol _symbol_p = this._symbols[offset + 6];
                CoffeeNode p = (CoffeeNode)((Object)_symbol_p.value);
                return new CoffeeForSourceNode(e, p, x);
            }
            case 161: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_w = this._symbols[offset + 4];
                List w = (List)_symbol_w.value;
                return new CoffeeSwitchNode(e, w);
            }
            case 162: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_w = this._symbols[offset + 4];
                List w = (List)_symbol_w.value;
                Symbol _symbol_b = this._symbols[offset + 6];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeSwitchNode(e, w, b);
            }
            case 163: {
                Symbol _symbol_w = this._symbols[offset + 3];
                List w = (List)_symbol_w.value;
                return new CoffeeSwitchNode(null, w);
            }
            case 164: {
                Symbol _symbol_w = this._symbols[offset + 3];
                List w = (List)_symbol_w.value;
                Symbol _symbol_b = this._symbols[offset + 5];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeSwitchNode(null, w, b);
            }
            case 165: {
                Symbol _symbol_w = this._symbols[offset + 1];
                CoffeeWhenNode w = (CoffeeWhenNode)((Object)_symbol_w.value);
                ArrayList<CoffeeWhenNode> lst = new ArrayList<CoffeeWhenNode>();
                lst.add(w);
                return new Symbol(lst);
            }
            case 166: {
                Symbol _symbol_s = this._symbols[offset + 1];
                List s = (List)_symbol_s.value;
                Symbol _symbol_w = this._symbols[offset + 2];
                CoffeeWhenNode w = (CoffeeWhenNode)((Object)_symbol_w.value);
                s.add(w);
                return new Symbol((Object)s);
            }
            case 167: {
                Symbol _symbol_a = this._symbols[offset + 2];
                List a = (List)_symbol_a.value;
                Symbol _symbol_b = this._symbols[offset + 3];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeWhenNode(a, b);
            }
            case 168: {
                Symbol _symbol_a = this._symbols[offset + 2];
                List a = (List)_symbol_a.value;
                Symbol _symbol_b = this._symbols[offset + 3];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeWhenNode(a, b);
            }
            case 169: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_b = this._symbols[offset + 3];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return new CoffeeIfNode(e, b, i);
            }
            case 170: {
                Symbol _symbol_i = this._symbols[offset + 1];
                CoffeeIfNode i = (CoffeeIfNode)((Object)_symbol_i.value);
                Symbol _symbol_f = this._symbols[offset + 3];
                String f = (String)_symbol_f.value;
                Symbol _symbol_e = this._symbols[offset + 4];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_b = this._symbols[offset + 5];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return i.addElse(new CoffeeIfNode(e, b, f));
            }
            case 172: {
                Symbol _symbol_i = this._symbols[offset + 1];
                CoffeeIfNode i = (CoffeeIfNode)((Object)_symbol_i.value);
                Symbol _symbol_b = this._symbols[offset + 3];
                CoffeeBlockNode b = (CoffeeBlockNode)((Object)_symbol_b.value);
                return i.addElse(b);
            }
            case 173: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CoffeeNode s = (CoffeeNode)((Object)_symbol_s.value);
                Symbol _symbol_p = this._symbols[offset + 2];
                String p = (String)_symbol_p.value;
                Symbol _symbol_e = this._symbols[offset + 3];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeIfNode(e, new CoffeeBlockNode(s), p, true);
            }
            case 174: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_p = this._symbols[offset + 2];
                String p = (String)_symbol_p.value;
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeIfNode(x, new CoffeeBlockNode(e), p, true);
            }
            case 175: {
                Symbol _symbol_u = this._symbols[offset + 1];
                String u = (String)_symbol_u.value;
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return CoffeeOpNode.create(u, e, null);
            }
            case 176: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeOpNode("-", e);
            }
            case 177: {
                Symbol _symbol_e = this._symbols[offset + 2];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeOpNode("+", e);
            }
            case 178: {
                Symbol _symbol_s = this._symbols[offset + 2];
                CoffeeValueNode s = (CoffeeValueNode)((Object)_symbol_s.value);
                return new CoffeeOpNode("--", s);
            }
            case 179: {
                Symbol _symbol_s = this._symbols[offset + 2];
                CoffeeValueNode s = (CoffeeValueNode)((Object)_symbol_s.value);
                return new CoffeeOpNode("++", s);
            }
            case 180: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeValueNode a = (CoffeeValueNode)((Object)_symbol_a.value);
                return new CoffeeOpNode("--", a, null, true);
            }
            case 181: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeValueNode a = (CoffeeValueNode)((Object)_symbol_a.value);
                return new CoffeeOpNode("++", a, null, true);
            }
            case 182: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeExistenceNode(e);
            }
            case 183: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeOpNode("+", e, x);
            }
            case 184: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeOpNode("-", e, x);
            }
            case 185: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_m = this._symbols[offset + 2];
                String m = (String)_symbol_m.value;
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeOpNode(m, e, x);
            }
            case 186: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeOpNode(s, e, x);
            }
            case 187: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeOpNode(c, e, x);
            }
            case 188: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_l = this._symbols[offset + 2];
                String l = (String)_symbol_l.value;
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                return new CoffeeOpNode(l, e, x);
            }
            case 189: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                String r = (String)_symbol_r.value;
                Symbol _symbol_x = this._symbols[offset + 3];
                CoffeeNode x = (CoffeeNode)((Object)_symbol_x.value);
                if (r.charAt(0) == '!') {
                    return new CoffeeOpNode(r.substring(1), e, x).invert();
                }
                return CoffeeOpNode.create(r, e, x);
            }
            case 190: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeValueNode a = (CoffeeValueNode)((Object)_symbol_a.value);
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_e = this._symbols[offset + 3];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeAssignNode(a, e, c);
            }
            case 191: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeValueNode a = (CoffeeValueNode)((Object)_symbol_a.value);
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_e = this._symbols[offset + 4];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeAssignNode(a, e, c);
            }
            case 192: {
                Symbol _symbol_a = this._symbols[offset + 1];
                CoffeeValueNode a = (CoffeeValueNode)((Object)_symbol_a.value);
                Symbol _symbol_e = this._symbols[offset + 3];
                CoffeeNode e = (CoffeeNode)((Object)_symbol_e.value);
                return new CoffeeExtendsNode(a, e);
            }
            case 48: {
                return new Symbol(null);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 49: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 71: 
            case 76: 
            case 120: 
            case 121: 
            case 149: 
            case 171: {
                return this._symbols[offset + 1];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    private class CoffeeEvents
    extends Parser.Events {
        private CoffeeEvents() {
        }

        public void scannerError(Scanner.Exception e) {
        }

        public void syntaxError(Symbol token) {
            if (token == null || CoffeeParser.this.fWorking == null) {
                return;
            }
            CoffeeParser.this.fWorking.addError((IParseError)new ParseError("com.aptana.contenttype.coffeescript", token, IProblem.Severity.ERROR));
        }

        public void unexpectedTokenRemoved(Symbol token) {
        }

        public void missingTokenInserted(Symbol token) {
        }

        public void misspelledTokenReplaced(Symbol token) {
        }

        public void errorPhraseRemoved(Symbol error) {
        }
    }
}

